/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.commands.commands;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.commands.Command;
import Krasnodar.rockstarnew.systems.commands.CommandBuilder;
import Krasnodar.rockstarnew.systems.commands.CommandContext;
import Krasnodar.rockstarnew.systems.commands.ValidationResult;
import Krasnodar.rockstarnew.systems.notifications.NotificationType;
import Krasnodar.rockstarnew.utility.game.MessageUtility;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import java.util.List;
import net.minecraft.class_2561;
import ru.kotopushka.compiler.sdk.annotations.Compile;

public class TestNotificationCommand
implements IMinecraft {
    @Compile
    public Command command() {
        return CommandBuilder.begin("testnotif").aliases("tn").desc("\u0422\u0435\u0441\u0442\u0438\u0440\u0443\u0435\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439 HUD").param("type", p -> p.validator(text -> {
            String[] validTypes;
            for (String type : validTypes = new String[]{"simple", "full"}) {
                if (!type.equalsIgnoreCase(text)) continue;
                return ValidationResult.ok(text);
            }
            return ValidationResult.error("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f");
        }).suggests(List.of("simple", "full"))).param("notifType", p -> p.validator(text -> {
            String[] validNotifTypes;
            for (String notifType : validNotifTypes = new String[]{"success", "error", "info"}) {
                if (!notifType.equalsIgnoreCase(text)) continue;
                return ValidationResult.ok(text);
            }
            return ValidationResult.error("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f");
        }).suggests(List.of("success", "error", "info"))).param("text", p -> p.vararg().validator(ValidationResult::ok)).handler(this::handle).build();
    }

    @Compile
    private void handle(CommandContext context) {
        List<Object> args = context.arguments();
        if (args.isEmpty()) {
            this.showHelp();
            return;
        }
        String type = args.get(0).toString().toLowerCase();
        if (args.size() < 2) {
            MessageUtility.error(class_2561.method_30163((String)"\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432"));
            this.showHelp();
            return;
        }
        String notifTypeStr = args.get(1).toString().toLowerCase();
        NotificationType notifType = this.parseNotificationType(notifTypeStr);
        if (notifType == null) {
            MessageUtility.error(class_2561.method_30163((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f! \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435: success, error, info"));
            return;
        }
        if (args.size() < 3) {
            MessageUtility.error(class_2561.method_30163((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0435\u043a\u0441\u0442 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f"));
            return;
        }
        List textParts = (List)args.get(2);
        if (textParts.isEmpty()) {
            MessageUtility.error(class_2561.method_30163((String)"\u0422\u0435\u043a\u0441\u0442 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c"));
            return;
        }
        switch (type) {
            case "simple": {
                String text = String.join((CharSequence)" ", textParts);
                Rockstar.getInstance().getNotificationManager().addNotification(notifType, text);
                MessageUtility.info(class_2561.method_30163((String)("\u041f\u0440\u043e\u0441\u0442\u043e\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e: " + text)));
                break;
            }
            case "full": {
                if (textParts.size() < 2) {
                    MessageUtility.error(class_2561.method_30163((String)"\u0414\u043b\u044f \u043f\u043e\u043b\u043d\u043e\u0433\u043e \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043d\u0443\u0436\u0435\u043d \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0438 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"));
                    return;
                }
                String title = (String)textParts.get(0);
                String desc = String.join((CharSequence)" ", textParts.subList(1, textParts.size()));
                Rockstar.getInstance().getNotificationManager().addNotificationOther(notifType, title, desc);
                MessageUtility.info(class_2561.method_30163((String)("\u041f\u043e\u043b\u043d\u043e\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e: " + title + " - " + desc)));
                break;
            }
            default: {
                MessageUtility.error(class_2561.method_30163((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043a\u043e\u043c\u0430\u043d\u0434\u044b"));
                this.showHelp();
            }
        }
    }

    private NotificationType parseNotificationType(String type) {
        return switch (type) {
            case "success" -> NotificationType.SUCCESS;
            case "error" -> NotificationType.ERROR;
            case "info" -> NotificationType.INFO;
            default -> null;
        };
    }

    private void showHelp() {
        MessageUtility.info(class_2561.method_30163((String)"=== \u0422\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439 ==="));
        MessageUtility.info(class_2561.method_30163((String)".testnotif simple <\u0442\u0438\u043f> <\u0442\u0435\u043a\u0441\u0442> - \u043f\u0440\u043e\u0441\u0442\u043e\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435"));
        MessageUtility.info(class_2561.method_30163((String)".testnotif full <\u0442\u0438\u043f> <\u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a> <\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435> - \u043f\u043e\u043b\u043d\u043e\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435"));
        MessageUtility.info(class_2561.method_30163((String)"\u0422\u0438\u043f\u044b: success, error, info"));
        MessageUtility.info(class_2561.method_30163((String)"\u041f\u0440\u0438\u043c\u0435\u0440: .testnotif simple success \u041c\u043e\u0434\u0443\u043b\u044c \u0432\u043a\u043b\u044e\u0447\u0435\u043d"));
        MessageUtility.info(class_2561.method_30163((String)"\u041f\u0440\u0438\u043c\u0435\u0440: .testnotif full error \u041e\u0448\u0438\u0431\u043a\u0430 \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443"));
    }
}

